﻿/* 
* @copyright Copyright (C) 2007-2010 Ryan Demmer. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
* This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
*/
class Player {
	//Objects
	private var nc:NetConnection;
	private var ns;
	private var audio:Sound;
	private var movie:String;
	private var stageListener:Object = new Object();
	private var mouseListener:Object = new Object();
	//Interval Ids
	private var loadInt:Number;
	private var playInt:Number;
	private var scrubInt:Number;
	private var volumeInt:Number;
	private var bufferInt:Number;
	private var mouseInt:Number;
	// Numbers
	private var videoTime:Number;
	private var progressTemp:Number;
	private var defaultVolume:Number = 100;
	private var ow:Number;
	private var oh:Number;
	//Booleans
	private var isLoaded:Boolean = false;
	private var isPaused:Boolean = true;
	private var isMuted:Boolean = false;
	private var isFullscreen:Boolean = false;
	//Other
	private var baseUrl:String = '';
	private var timeFormat:String = 'up';
	//External Configuration variables
	private var options:Object = {file:"playlist.xml", background: 'color', backcolor:0x999999, frontcolor:0x333333, lightcolor:0x999999, screencolor:0x000000, bufferlength:5, image:false, autostart:false, repeat:false, mute:false, vol:100};
	//Constructor
	public function Player() {
		//Setup config variables
		for (var n in this.options) {
			if (_root[n] != undefined) {
				this.options[n] = _root[n];
				if (this.options[n] == 'true' || this.options[n] == '1') {
					this.options[n] = true;
				}
				if (this.options[n] == 'false' || this.options[n] == '0') {
					this.options[n] = false;
				}
			}
		}
		initPlayer();
	}
	private function initPlayer() {
		var t = this;
		this.parseFile();
		
		if(this.isMp3()){
			this.ns = new Sound();
			this.ns.onLoad = function(){
				t.videoTime = t.ns.duration;
			}
			this.ns.onSoundComplete = function(){
				_root.controller.progress_bar.progress_play._width = 0;
				if (t.options.repeat) {
					t.playVideo();
				} else {
					t.pauseVideo();
				}
				_root.controller.timer.txt.text = '00:00';
			}
			// Hide fullscreen button
			_root.controller.fs_btn._visible = false;
		}else{
			//Setup video connections
			this.nc = new NetConnection();
			this.nc.connect(null);
			this.ns = new NetStream(this.nc);
			this.ns.setBufferTime(this.options.bufferlength);
			
			_root.videoContainer.smoothing = true;
			_root.videoContainer.attachVideo(this.ns);
	
			var imageLoader:MovieClip = _root.createEmptyMovieClip("imageLoader", _root.videoBackground.getDepth()+1);
			if (this.checkVersion('9.0.28')) {
				_root.imageLoader.forceSmoothing = true;
			}
			if (this.options.image && !this.options.autostart) {
				_root.imageLoader.loadMovie(this.makeFile(this.options.image));
			}
			this.ns.onMetaData = function(object:Object) {
				t.videoTime = object.duration;
			};
			this.ns.onStatus = function(obj:Object) {
				switch (obj.code) {
					case "NetStream.Play.Stop" :
						t.ns.seek(0.01);
						_root.controller.progress_bar.progress_play._width = 0;
						if (t.options.repeat) {
							t.playVideo();
						} else {
							t.pauseVideo();
						}
						_root.controller.timer.txt.text = '00:00';
						
						break;
					case "NetStream.Play.Start" :
						this.setPlay(false);
						_root.spinner._visible = true;
						break;
					case "NetStream.Play.StreamNotFound" :
						t.setText("Unable to load file");
						break;
					case "NetStream.Buffer.Flush" :
					case "NetStream.Buffer.Full" :
						_root.spinner._visible = false;
						break;
					case "NetStream.Buffer.Empty" :
						_root.spinner._visible = true;
						this.setPlay(false);
						break;
				}
			};
			_root.videoBackground.onPress = function() {
				if (t.isPaused) {
					t.playVideo();
				} else {
					t.pauseVideo();
				}
			};
			_root.bigPlay.onPress = function() {
				t.playVideo();
			};
		}
		
		this.ow = Stage.width;
		this.oh = Stage.height-16;

		this.buildPlayer(false);
		_root.controller.progress_bar.progress_play._width = 0;
		_root.controller.progress_bar.progress_load._width = 0;

		_root.spinner._visible = false;
		_root.infoTxt._visible = false;

		//Set button states
		this.setPlay(true);
		_root.controller.timer.txt.text = '00:00';

		this.setColors();
		this.initSound();
		
		_root.controller.play_btn.onPress = function() {
			if (t.isPaused) {
				t.playVideo();
			} else {
				t.pauseVideo();
			}
		};
		_root.controller.volume_bar.mute_btn.onPress = function() {
			t.muteVideo();
		};
		_root.controller.timer.onPress = function() {
			t.timeFormat = t.timeFormat == 'up' ? 'down' : 'up';
			t.updateTime();
		};
		_root.controller.progress_bar.progress_load.onPress = function() {
			t.scrubInt = setInterval(t, 'scrubVideo', 10);
		};
		_root.controller.progress_bar.progress_load.onRelease = _root.controller.progress_bar.progress_load.onReleaseOutside=function () {
			clearInterval(t.scrubInt);
		};
		_root.controller.volume_bar.volume_btn.onPress = function() {
			t.volumeInt = setInterval(t, 'setVideoVolume', 10);
		};
		_root.controller.volume_bar.volume_btn.onRelease = _root.controller.volume_bar.volume_btn.onReleaseOutside=function () {
			clearInterval(t.volumeInt);
		};

		if (this.checkVersion('9.0.28')) {
			Stage["displayState"] = "normal";

			_root.controller.fs_btn.onPress = function() {
				Stage["displayState"] = Stage["displayState"] == "fullScreen" ? "normal" : "fullScreen";
			};
			stageListener.onFullScreen = function(fs:Boolean) {
				t.buildPlayer(fs);
			};
			Stage.addListener(stageListener);
		} else {
			this.setColor(_root.controller.fs_btn.fs_icon,this.options.lightcolor);
			_root.controller.fs_btn.onRollOver = function() {
				t.setText('Fullscreen mode requires Flash Player 9.0.28+');
			};
			_root.controller.fs_btn.onRollOut = function() {
				t.setText('');
			};
		}

		if (this.options.autostart) {
			this.playVideo();
		}
	}
	private function buildPlayer(fs:Boolean) {
		var t = this;
		var sw:Number = Stage.width;
		var sh:Number = Stage.height;

		var w:Number = fs ? sw*0.9 : sw;
		var h:Number = fs ? sh : sh-16;

		var y_pos:Number = fs ? h-h*0.1 : h;

		var x_pos_lft:Number = fs ? sw*0.05 : 0;
		var x_pos_rt:Number = sw-x_pos_lft;

		var vw = sw;
		var vh = h;

		_root.videoContainer._x = 0;
		_root.videoContainer._y = 0;

		if (fs) {
			var dim = this.getVideoDimensions();
			vw = dim['width'];
			vh = dim['height'];

			_root.videoContainer._x = (sw-vw)/2;
			_root.videoContainer._y = (sh-vh)/2;
		}
		//Video Container        
		_root.videoContainer._width = vw;
		_root.videoContainer._height = vh;
		//VideoBg
		_root.videoBackground._width = sw;
		_root.videoBackground._height = h;
		// Image Loader
		_root.onEnterFrame = function() {
			if (_root.imageLoader && _root.imageLoader._width>0) {
				delete _root.onEnterFrame;
				_root.imageLoader._width = sw;
				_root.imageLoader._height = h;
				
				_root.imageLoader._visible = !fs;
			}
		};
		
		if (fs) {
			mouseInt = setInterval(this, 'hideController', 5000);
			mouseListener.onMouseMove = function() {
				_root.controller._visible = true;
				Mouse.show();
			};
			Mouse.addListener(mouseListener);
		} else {
			clearInterval(mouseInt);
			_root.controller._visible = true;
			Mouse.show();
			Mouse.removeListener(mouseListener);
		}
		// Controller
		_root.controller.bg._width = w;
		_root.controller.edge._width = w;
		_root.controller._y = y_pos;
		_root.controller._x = x_pos_lft;
		// Controller buttons
		var cw = w;
		if( _root.controller.fs_btn._visible ){
			_root.controller.fs_btn._x = cw;
			cw = cw - _root.controller.fs_btn._width;
		}
		_root.controller.volume_bar._x = cw;
		_root.controller.timer._x = cw - _root.controller.volume_bar._width;

		//Progress Bars
		var lb:Number = cw-(_root.controller.play_btn._width + _root.controller.timer._width + _root.controller.volume_bar._width);
		
		_root.controller.progress_bar.bar._width = lb;
		_root.controller.progress_bar.edge._width = lb;
		this.progressTemp = lb - 4;
		
		this.updateLoadProgress();
		this.updatePlayProgress();

		var hsw:Number = sw/2;
		var hsh:Number = h/2;

		//Text  
		_root.infoTxt._x = hsw-_root.infoTxt._width/2;
		_root.infoTxt._y = hsh-_root.infoTxt._height/2+_root.bigPlay._height;
		//Big Play
		_root.bigPlay._x = hsw-_root.bigPlay._width/2;
		_root.bigPlay._y = hsh-_root.bigPlay._height/2;
		//Spinner
		_root.spinner._x = hsw-_root.spinner._width/2;
		_root.spinner._y = hsh-_root.spinner._height/2;

		// Update color...
		this.setColor(_root.controller.fs_btn.fs_icon,this.options.frontcolor);
	}
	private function setColors() {
		var t = this;
		var fc = this.options.frontcolor;
		var bc = this.options.backcolor;
		var lc = this.options.lightcolor;
		
		// Background
		if(this.options.background == 'color'){
			this.setColor(_root.videoBackground, this.options.screencolor);
		}
		if(this.options.background == 'transparent'){
			_root.videoBackground._alpha = 0;
		}
		
		// Play button
		this.setColor(_root.controller.play_btn.edge, fc);
		this.setColor(_root.controller.play_btn.play_icon, fc);
		_root.controller.play_btn.onRollOver = function() {
			t.setColor(_root.controller.play_btn.play_icon, lc);
			t.setColor(_root.controller.play_btn.pause_icon, lc);
		};
		_root.controller.play_btn.onRollOut = function() {
			t.setColor(_root.controller.play_btn.play_icon, fc);
			t.setColor(_root.controller.play_btn.pause_icon, fc);
		};
		// Pause button
		this.setColor(_root.controller.play_btn.pause_icon, fc);

		// Fullscreen button
		this.setColor(_root.controller.fs_btn.edge, fc);
		_root.controller.fs_btn.onRollOver = function() {
			t.setColor(_root.controller.fs_btn.fs_icon, lc);
		};
		_root.controller.fs_btn.onRollOut = function() {
			t.setColor(_root.controller.fs_btn.fs_icon, fc);
		};
		// Mute Button
		this.setColor(_root.controller.volume_bar.mute_btn.mute_icon, fc);
		_root.controller.volume_bar.mute_btn.onRollOver = function() {
			t.setColor(_root.controller.volume_bar.mute_btn.mute_icon, lc);
		};
		_root.controller.volume_bar.mute_btn.onRollOut = function() {
			t.setColor(_root.controller.volume_bar.mute_btn.mute_icon, fc);
		};
		// volume
		this.setColor(_root.controller.volume_bar.edge, fc);
		this.setColor(_root.controller.volume_bar.volume_btn.volume_icon.drag, fc);
		this.setColor(_root.controller.volume_bar.volume_btn.volume_icon.hit, lc);
		// progress bar
		this.setColor(_root.controller.progress_bar.edge, fc);
		this.setColor(_root.controller.progress_bar.progress_play, fc);
		this.setColor(_root.controller.progress_bar.progress_load, lc);
		
		this.setColor(_root.controller.bg, bc);

		this.setColor(_root.videoBackground, this.options.screencolor);

		// Time
		_root.controller.timer.txt.textColor = fc;
		_root.controller.timer.onRollOver = function() {
			_root.controller.timer.txt.textColor = lc;
		};
		_root.controller.timer.onRollOut = function() {
			_root.controller.timer.txt.textColor = fc;
		};
	}
	private function hideController() {
		if (_root.controller.hitTest(_root._xmouse, _root._ymouse, true)) {
			return false;
		}
		_root.controller._visible = false;
		Mouse.hide();
	}
	private function initSound() {
		if(this.isMp3()){
			this.audio = this.ns;
		}else{
			_root.createEmptyMovieClip("videoSound",_root.getNextHighestDepth());
			_root.videoSound.attachAudio(this.ns);
			this.audio = new Sound(_root.videoSound);
		}
		this.setVideoVolume(this.options.vol);
		this.isMuted = !this.options.mute;
		this.muteVideo();
	}
	private function playVideo() {
		if (!this.isLoaded) {
			return false;
		}
		
		_root.imageLoader._visible = false;
		
		if(this.isMp3()){
			_root.spinner._visible = false;
		}else{
			if (this.ns.bufferLength<this.ns.bufferTime) {
				_root.spinner._visible = true;
			} else {
				_root.spinner._visible = false;
			}
		}
		this.isPaused = false;
		this.setPlay(false);
		
		var bl = this.isMp3() ? this.ns.getBytesLoaded() : this.ns.bytesLoaded;
		if (!bl) {
			if (this.movie != undefined) {
				if(this.isMp3()){
					this.ns.loadSound(this.makeFile(this.movie), true);
					this.ns.start();
				}else{
					this.ns.play(this.makeFile(this.movie));
				}
			} else {
				_root.infoText.text = "No file specified";
				this.setPlay(true);
			}
			if (this.isMuted) {
				this.audio.setVolume(0);
				_root.controller.volume_bar.volume_btn.volume_icon.drag._xscale = 0;
			} else {
				this.audio.setVolume(this.defaultVolume);
				_root.controller.volume_bar.volume_btn.volume_icon.drag._xscale = this.defaultVolume;
			}
			this.loadInt = setInterval(this, 'updateLoadProgress', 10);
		} else {
			this.isMp3() ? this.ns.start(this.ns.position / 1000) : this.ns.pause(false);
		}
		this.playInt = setInterval(this, 'updatePlayProgress', 10);
	}
	private function setPlay(st:Boolean):Void {
		_root.controller.play_btn.pause_icon._visible = !st;
		_root.controller.play_btn.play_icon._visible = st;
		_root.bigPlay._visible = this.isMp3() ? false : st;
	}
	private function pauseVideo():Void {
		this.isPaused = true;
		this.setPlay(true);
		this.isMp3() ? this.ns.stop() : this.ns.pause();
		clearInterval(this.playInt);
		_root.spinner._visible = false;
	}
	private function muteVideo() {
		if (this.isMuted) {
			this.audio.setVolume(this.defaultVolume);
			_root.controller.volume_bar.volume_btn.volume_icon.drag._xscale = this.defaultVolume;
			this.isMuted = false;
		} else if (!this.isMuted) {
			this.audio.setVolume(0);
			_root.controller.volume_bar.volume_btn.volume_icon.drag._xscale = 0;
			this.isMuted = true;
		}
	}
	function setVideoVolume(n:Number) {
		var v:Number = _root.controller.volume_bar.volume_btn.volume_icon.hit._width;
		if(!n){
			n = _root.controller.volume_bar.volume_btn.volume_icon._xmouse/v*100;
		}
		if (n>100) {
			n = 100;
		}
		if (n<0) {
			n = 0;
		}
		_root.controller.volume_bar.volume_btn.volume_icon.drag._width = v*n/100;
		this.defaultVolume = n;
		this.audio.setVolume(n);
	}
	function scrubVideo() {
		var pl:MovieClip = _root.controller.progress_bar.progress_load;
		var xMouse:Number = pl._xmouse*pl._width;
		if (xMouse>pl._width) {
			xMouse = pl._width;
		}
		if (xMouse<0) {
			xMouse = 0;
		}
		_root.controller.progress_bar.progress_play._width = xMouse;
		var pct:Number = xMouse/pl._width*100;
		var pos:Number = this.videoTime/100*pct;
		if(this.isMp3()){
			this.ns.start(pos / 1000);
			this.updateTime(pos / 1000);
		}else{
			this.ns.seek(pos);
			this.updateTime(pos);
		}
	}
	private function updatePlayProgress() {
		var time = this.isMp3() ? this.ns.position : this.ns.time;
		
		_root.controller.progress_bar.progress_play._width = time /  this.videoTime * this.progressTemp;
		this.updateTime();
	}
	private function updateTime(time:Number) {
		if (!time) {
			time = this.isMp3() ? this.ns.position / 1000 : this.ns.time;
		}
		if (this.timeFormat == 'down') {
			time = this.isMp3() ? this.videoTime / 1000 - time : this.videoTime-time;
		}
		if (isNaN(time)) {
			time = 0;
		}
		var minutes = Math.floor(time/60);
		var seconds = Math.floor(time%60);

		if (minutes<10) {
			minutes = "0"+minutes;
		}
		if (seconds<10) {
			seconds = "0"+seconds;
		}
		_root.controller.timer.txt.text = minutes+":"+seconds;
	}
	private function updateLoadProgress() {
		var bl = this.isMp3() ? this.ns.getBytesLoaded() : this.ns.bytesLoaded;
		var bt = this.isMp3() ? this.ns.getBytesTotal() : this.ns.bytesTotal;
		var p:Number = bl/bt*this.progressTemp;
		_root.controller.progress_bar.progress_load._width = p;
		if (p>=this.progressTemp) {
			clearInterval(this.loadInt);
		}
	}
	//Auxilary functions
	private function parseFile() {
		var src:String = this.options.file;
		this.setPlay(true);
		_root.spinner._visible = true;
		var t = this;
		if (this.getExtension(src) == 'xml') {
			var playlist:XML = new XML();
			playlist.ignoreWhite = true;
			playlist.load(this.makeFile(src));
			playlist.onLoad = function(success) {
				if (success) {
					_root.spinner._visible = false;
					this.setPlay(true);
					t.isLoaded = true;
					var tracklist = playlist.firstChild.childNodes;
					var track = tracklist[0].firstChild.childNodes;
					for (var i = 0; i<track.length; i++) {
						if (track[i].nodeName == 'location') {
							t.movie = track[i].firstChild;
						}
					}
				} else {
					_root.spinner._visible = false;
					t.setText("Unable to load file!");
				}
			};
		} else {
			this.movie = src;
			this.isLoaded = true;
			this.setPlay(true);
			_root.spinner._visible = false;
		}
	}
	private function makeFile(url:String) {
		if (url.indexOf('://') == -1) {
			url = this.getUrl()+url;
		}
		return url;
	}
	private function getUrl() {
		var url = _root._url;
		url = url.substring(0, url.lastIndexOf(this.baseUrl));
		return url;
	}
	private function checkVersion(required:String) {
		var v:String = getVersion();
		v = v.replace(",", "", "g");
		required = required.replace(",", "", "g");
		var n:Number = parseInt(v);
		var m:Number = parseInt(required);
		return n>=m;
	}
	private function getExtension(file:String) {
		var arr:Array = file.split('.');
		var ext:String = arr[arr.length-1];
		return ext.toLowerCase();
	}
	private function setColor(mc:MovieClip, col:Number) {
		var color:Color = new Color(mc);
		color.setRGB(col);
	}
	private function getVideoDimensions() {
		var sw = Stage.width;
		var sh = Stage.height;

		var w = this.ow;
		var h = this.oh;

		if (w>h) {
			h = h*(sw/w);
			w = sw;
			if (h>sh) {
				w = w*(sh/h);
				h = sh;
			}
		} else {
			w = w*(sh/h);
			h = sh;
			if (w>sw) {
				h = h*(sw/w);
				w = sw;
			}
		}
		w = Math.round(w);
		h = Math.round(h);

		var dim:Object = {width:w, height:h};
		return dim;
	}
	private function isMp3(){
		return this.getExtension(this.movie) == 'mp3';
	}
	private function setText(txt:String) {
		_root.infoTxt._visible = txt.length;
		_root.infoTxt.txt.text = txt;
	}
}