if (typeof(MooTools) != 'undefined'){

    var DropdownVtemmenu = new Class({
        Implements: Options,
        options: {
            mooTransition : 'Bounce',
            mooEase : 'easeOut',
            mooDuree : 500,
            useOpacity : '0',
            menuID : 'vt_menu',
            testoverflow : '1',
            orientation : '0',
            dureeOut : 500
        },
			
        initialize: function(element,options) {
			
            this.setOptions(options);

            var maduree = this.options.mooDuree;
            var matransition = this.options.mooTransition;
            var monease = this.options.mooEase;
            var useopacity = this.options.useOpacity;
            var dureeout = this.options.dureeOut;
            var menuID = this.options.menuID;
            var testoverflow = this.options.testoverflow;
            var orientation = this.options.orientation;

            var els = element.getElements('li');

            els.each(function(el) {
										
                if (el.getElement('div.vt_nav') != null) {
                    el.container = el.getElement('div.vt_nav');
					el.container.setStyle('top',el.clientHeight+'px');	
                    el.containerul = el.getElements('div.vt_nav ul');
                    el.containerul.setStyle('position','static');
						
                    el.container.mh = el.container.clientHeight;
                    el.container.mw = el.container.clientWidth;
                    el.duree = maduree;
                    el.transition = matransition;
                    el.ease = monease;
                    el.useopacity = useopacity;
                    el.orientation = orientation;
                    el.zindex = el.getStyle('z-index');
                    el.createFxVTEM();

                    el.addEvent('mouseover',function() {
                        
                        if (testoverflow == '1') this.testOverflowVTEM(menuID);
                        this.showVTEM();

                    });
                    el.addEvent('mouseleave',function() {
							
                        this.hideVTEM(dureeout);
							
                    });
                }
            });
        }
			
    });

    if (MooTools.version > '1.12' ) Element.extend = Element.implement;

       
    Element.extend({

        testOverflowVTEM: function(menuID) {
            var limite = $(menuID).offsetWidth + $(menuID).getLeft();


            if (this.hasClass('parent')) {
                var largeur = this.container.mw + 180;
                if (this.hasClass('level0')) largeur = this.container.mw;

                var positionx = this.getLeft() + largeur;

                if (positionx > limite) {
                    this.getElement('div.vt_nav').addClass('fixRight');
                    this.setStyle('z-index','15000');
                }
				
            }

        },

               
        createFxVTEM: function() {
			
            var myTransition = new Fx.Transition(Fx.Transitions[this.transition][this.ease]);
            if (this.hasClass('level0') && this.orientation != '1')
            {
                this.vtemFxVT = new Fx.Tween(this.container, {
                    property:'height',
                    duration:this.duree,
                    transition: myTransition});
            } else {
                this.vtemFxVT = new Fx.Tween(this.container, {
                    property:'width',
                    duration:this.duree,
                    transition: myTransition});
            }

            if (this.useopacity == '1') {
                this.vtemOpacityVT = new Fx.Style(this.container, 'opacity', {
                    duration:this.duree
                });
                this.vtemOpacityVT.set(0);
            }
            

            this.vtemFxVT.set(0);
            
            this.container.setStyle('left', '-999em');
				
            animComp = function(){
                if (this.status == 'hide')
                {
                    this.container.setStyle('left', '-999em');
                    this.hidding = 0;
                    this.setStyle('z-index',this.zindex);
                }
                this.showing = 0;
                this.container.setStyle('overflow', '');
					
            }
            this.vtemFxVT.addEvent ('onComplete', animComp.bind(this));

        },
			
        showVTEM: function() {
            clearTimeout (this.timeout);
            this.addClass('vtem_menu_hover');
            this.status = 'show';
            this.animVTEM();
        },
			
        hideVTEM: function(timeout) {
            this.status = 'hide';
            this.removeClass('vtem_menu_hover');
            clearTimeout (this.timeout);
            if (timeout)
            {
                this.timeout = setTimeout (this.animVTEM.bind(this), timeout);
            }else{
                this.animVTEM();
            }
        },

        animVTEM: function() {

            if ((this.status == 'hide' && this.container.style.left != 'auto') || (this.status == 'show' && this.container.style.left == 'auto' && !this.hidding) ) return;
					
            this.container.setStyle('overflow', 'hidden');
            if (this.status == 'show') {
                this.hidding = 0;
            }
            if (this.status == 'hide')
            {
                this.hidding = 1;
                this.showing = 0;
                this.vtemFxVT.cancel();
					
                if (this.hasClass('level0') && this.orientation != '1') {
                    this.vtemFxVT.start(this.container.offsetHeight,0);
                } else {
                    this.vtemFxVT.start(this.container.offsetWidth,0);
                }
                if (this.useopacity == '1') {
                    this.vtemOpacityVT.cancel();
                    this.vtemOpacityVT.start(1,0);
                }
                

            } else {
                this.showing = 1;
                this.container.setStyle('left', 'auto');
                this.vtemFxVT.cancel();
                if (this.hasClass('level0') && this.orientation != '1') {
                    this.vtemFxVT.start(this.container.offsetHeight,this.container.mh);
                } else {
                    this.vtemFxVT.start(this.container.offsetWidth,this.container.mw);
                }
                if (this.useopacity == '1') {
                    this.vtemOpacityVT.cancel();
                    this.vtemOpacityVT.start(0,1);
                }
                
            }
				

        }
    });
    DropdownVtemmenu.implement(new Options);
}